$fn = 200;

platformWidth = 20;
screwRadius = 1.5;
boltRadius = 2;
thickness = 2;
platformLength = 40.215;
spacerHeight = 19;

translate([10,0,0]){
    spacer6(spacerHeight);
}

translate([20,0,0]){
    spacer6(spacerHeight);
}

translate([20,10,0]){
    spacer6(spacerHeight+7.5);
}

translate([10,10,0]){
    spacer6(spacerHeight+7.5);
}

translate([0,0,platformWidth/2]){
    rotate([0,90,0]){
        difference(){
            cube([platformWidth, platformLength, thickness], center = true);
            cylinder(thickness*2, screwRadius, screwRadius, center = true);
        }
        rotate([0,90,0]){
            translate([boltRadius + 2.3/2,platformLength/2,-platformWidth/2]){
                spacer6(platformWidth);
            }
        }
        rotate([0,90,0]){
            translate([boltRadius + 2.3/2,-platformLength/2,-platformWidth/2]){
                spacer6(platformWidth);
            }
        }
    }
}

module spacer6(functionHeight){
    number6BoltRadius = 2;
    functionThickness = 2.3;
    translate([0,0,functionHeight/2]){
        difference(){
            cylinder(functionHeight, number6BoltRadius+functionThickness, number6BoltRadius+functionThickness, center = true);
            cylinder(functionHeight+1, number6BoltRadius, number6BoltRadius, center = true);
        }
    }
}